# 問題作成クイック・スタート・ガイド2：問題変数

[1 - 基本的な問題](Authoring_quick_start_1.md) | 2 - 問題変数 | [3 - フィードバックを改善する](Authoring_quick_start_3.md) | [4 - ランダム化](Authoring_quick_start_4.md) | [5 - 問題のテスト](Authoring_quick_start_5.md) | [6 - 複数解答問題](Authoring_quick_start_6.md) | [7 - 数式簡略の無効化](Authoring_quick_start_7.md) | [8 - 問題のインポートと小テスト](Authoring_quick_start_8.md)


問題作成クイック・スタート・ガイドのこの部分では問題変数の使用について扱います。次のビデオでそのプロセスを説明していますので,ご覧ください。：
<iframe width="560" height="315" src="https://www.youtube.com/embed/SFo3MBkyWVQ" frameborder="0" allowfullscreen></iframe>

## 例題

この例では,簡単な積分の問題を扱います。下記は典型的な練習問題です。

![積分の練習問題](../../content/IntegrationExercises.jpg)

( _Advanced Mathematics for AS and A level 2_ (A-level mathematics), Haese Mathematics (2018) [978-1-925489-32-3](http://www.haesemathematics.com/books/advanced-mathematics-2-for-a-level) より許可を得て転載)

\(\int 3(x-1)^{-4} \mathrm{d}x\)を求める問題を作成しましょう。新しいSTACK問題を作成します。前と同じように,問題に「積分の例」のような**問題名**を付けます。

### 問題変数の使用

次のステップは問題文を追加し,教師の答え `-1*(x-1)^(-3)+c` を `正解` フィールドと `ポテンシャル・レスポンス・ツリー` に追加することです。しかし,式と模範解答は通常複数回参照されますので,オプションの [問題変数](../../en/Authoring/Variables.md#Question_variables) フィールドを使用して「問題変数」に割り当てるのが最も簡単です。

問題変数に以下を追加してください

```
exp: 3*(x-1)^(-4)；
ta: int(exp,x)+c；
```

問題変数のコーディングはMaximaの文法に基づいています。特に,コロン `:` は変数に値を代入するために使われます。つまり,`a1` に `5` という値を代入するには,`a1:5` という構文を使います。一般的に,1文字の変数名は生徒が入力するためのものであるため,複数文字の変数名をつけるとよいです。なぜなら,デフォルトでは複数文字の変数は生徒が入力できないからです。さらに,各行の最後にセミコロンを追加することは任意ですが,つけておくことをお勧めします。

不定積分を求めるために`int()`関数を呼び出して模範解答を決定するためにCASを使用しています。CASが不定積分を決定するとき,積分定数は含まれないので,自分で追加しておきます。

これで，問題文の入力がかなり速くなります．問題テキストに次のように書き加えてください：

	積分 \(\int{@exp@} \mathrm{d}x\)　を計算せよ。
	[[input:ans1]] [[validation:ans1]]


変数 `exp` を定義し,問題テキストで使ってます。LaTeXの数式の`\(..\)`記号と `{@..@}` 記号の違いに注意してください。フィードバックも含め,問題編集内のテキストベースのフィールドはすべて[CAS text](../../en/Authoring/CASText.md)です。これは数学が挿入できるHTMLです。LaTeXは `\(.. \)` の間に記述され,CASの記述（変数も含む）は `{@..@}`の間に記述します。CASの記述は問題変数を参照して評価され,LaTeXとして表示されます。

ここでは`{@exp@}`を使用しているため,問題がインスタンス化されたとき,画面上 に`exp`は表示されず，`exp`の値である \(\frac{3}{(x-1)^{-4}}\) が表示されます。

解答欄：`ans1` で,`正解` に変数 `ta` に指定してください。

ポテンシャル・レスポンス・ツリーでは,`評価関数` を `代数等価`, `評価対象` を `ans1`, `評価基準` を `ta` に設定してください。

問題変数の使用は時間の節約になり,将来的に質問の内容を簡単に変更できるので,頻繁に使用することをお勧めします。

# 次のステップ

これでSTACKで問題変数を使えるようになりました。

#### オーサリングクイックスタートガイドの次のパートでは,[フィードバックの改善](Authoring_quick_start_3.md)について説明します。