/**
 * A javascript module to handle requests for library question info
 * and to import questions.
 *
 * @module     qtype_stack/library
 * @copyright  2024 The University of Edinburgh
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("qtype_stack/library",["core/ajax","core_filters/events"],(function(Ajax,CustomEvents){let categoryId=null,libraryDiv=null,rawDiv=null,variablesDiv=null,descriptionDiv=null,importListDiv=null,importSuccessDiv=null,importSuccessFileDiv=null,displayedDiv=null,dashLink=null,errorDiv=null,currentPath=null,currentName=null,isstack=!1;function libraryRender(e){const filepath=e.target.getAttribute("data-filepath");currentPath=filepath,loading(!0),errorDiv.hidden=!0,categoryId=Number(document.getElementById("id_category").value.split(",")[0]),Ajax.call([{methodname:"qtype_stack_library_render",args:{category:categoryId,filepath:filepath},done:function(response){loading(!1),libraryDiv.innerHTML=response.questionrender;for(const iframe of response.iframes)require(["qtype_stack/stackjsvle"],(function(stackjsvle){stackjsvle.create_iframe(iframe.iframeid,iframe.content,iframe.targetdivid,iframe.title,iframe.scrolling,iframe.evil)}));rawDiv.innerHTML=response.questiontext,descriptionDiv.innerHTML=response.questiondescription,variablesDiv.innerHTML=response.questionvariables.replace(/;/g,";<br>"),displayedDiv.innerHTML=response.questionname+"<br>("+currentPath.split("/").pop()+")",currentName=response.questionname,isstack=response.isstack,document.querySelectorAll(".library-secondary-info").forEach((el=>el.removeAttribute("hidden"))),document.querySelector(".library-import-link").removeAttribute("disabled"),CustomEvents.notifyFilterContentUpdated(libraryDiv)},fail:function(){loading(!1),errorDiv.hidden=!1}}])}function libraryImport(){if(!currentPath)return;errorDiv.hidden=!0;const filepath=currentPath;loading(!0),categoryId=Number(document.getElementById("id_category").value.split(",")[0]),Ajax.call([{methodname:"qtype_stack_library_import",args:{category:categoryId,filepath:filepath},done:function(response){if(loading(!1),response.success){let currentDashLink=dashLink+response.questionid;importListDiv.innerHTML=isstack?importListDiv.innerHTML+'<br><a target="_blank" href="'+currentDashLink+'">'+currentName+"</a>":importListDiv.innerHTML+"<br>"+currentName,importSuccessFileDiv.innerHTML=currentPath.split("/").pop()+" as "+currentName,importSuccessDiv.removeAttribute("hidden")}else errorDiv.hidden=!1},fail:function(){loading(!1),errorDiv.hidden=!1}}])}function loading(isLoading){errorDiv.hidden=!0,isLoading?(document.querySelector(".loading-display").removeAttribute("hidden"),document.querySelector(".library-import-link").setAttribute("disabled","disabled"),document.querySelectorAll(".library-file-link").forEach((el=>el.setAttribute("disabled","disabled"))),importSuccessDiv.setAttribute("hidden",!0)):(document.querySelector(".loading-display").setAttribute("hidden",!0),document.querySelectorAll(".library-file-link").forEach((el=>el.removeAttribute("disabled"))))}return{setup:function(){libraryDiv=document.querySelector(".stack_library_display"),rawDiv=document.querySelector(".stack_library_raw_display"),variablesDiv=document.querySelector(".stack_library_variables_display"),importListDiv=document.querySelector(".stack-library-imported-list"),displayedDiv=document.querySelector(".stack_library_selected_question"),descriptionDiv=document.querySelector(".stack_library_description_display"),errorDiv=document.querySelector(".stack-library-error"),importSuccessDiv=document.querySelector(".stack-library-import-success"),importSuccessFileDiv=document.querySelector(".stack-library-import-success-file"),dashLink=document.querySelector("#dashboard-link-holder").innerHTML.trim(),dashLink=dashLink.includes("?")?dashLink+="&questionid=":dashLink+="?questionid=",loading(!0),document.querySelectorAll(".library-file-link").forEach((function(elem){elem.addEventListener("click",libraryRender)})),document.querySelector(".library-import-link").addEventListener("click",libraryImport);const catOptions=document.querySelectorAll("#id_category option");for(let option of catOptions){const sections=option.text.split("(");sections.length>1&&(sections[0]||sections.length>2)&&(sections.pop(),option.text=sections.join("("))}loading(!1)}}}));

//# sourceMappingURL=library.min.js.map