# Answer assessment

## How are my answers assessed? ##

A STACK question may have one or more _parts_. Each part may have one or more _inputs_,
such as typing in a mathematical expression as your answer. An individual mathematical expression
you type might be used in more than one part. This sounds complicated, but since there are many
possibilities it is difficult to make general statements. The question should be clear.  If not, please ask your teacher.

If you need to answer a part but have not then you will be told to do so.
You should normally answer all the parts!

Your answers are assessed in a two-stage process.

1. Your answer must be _valid_.
2. Once all answers relevant to a part are valid the _mathematical properties_ will be established.
   What properties are required depends on the question being asked!

Sometimes these processes are done in one step, sometimes you will need to submit a page twice. Therefore you should answer parts of a question and press `check` to validate your answer. If all parts are valid, then you should press `check` again to ask for your answer to be assessed.

You may change your answer. Just press `check` to validate and then `check` again to assess.
The system keeps track of any changes you make.

You will never lose marks for making a syntax error, e.g. missing a closing bracket.   However, you may type in a valid expression which is not what you meant and which is wrong.  You need to learn how to express yourself using an unambiguous syntax.  This is simple and comes to most students easily with practice.   If you make a mathematical mistake you should try to do the question again!

If you have asked for a worked solution then you may not change any of your answers.

Mathematical expressions are normally entered using a typed linear syntax. For more details, see [input](Answer_input.md).

## Repeated attempts ##

STACK encourages repeated attempts if you do not get the correct answer first time.
Normally, a small percentage (e.g. 10%) of the marks available for the question are deducted for each _valid_ but incorrect attempt.
However, your final mark will be the maximum mark you achieve over all attempts.
You are never worse off trying a partially correct question again.

## Why is my answer invalid? ##

Only when _all_ the interaction elements for a question part are valid do we consider
assessing your answer to the question. The validation process is designed to help you
express your mathematics in the correct form and in an unambiguous way.
On paper we might "know what you meant" but with the computer you have to "say what you mean".
You do not lose marks if one of your interaction elements is invalid so do not be afraid of typing
in your answer. Feedback is always provided.

There are a number of reasons why your answer could be considered to be invalid.

* You may have a syntax error in your answer, such as mismatched brackets.
* Variables in your answers should be single letters only.
* The range of Maxima functions you are permitted to type in is limited to mathematical ones, not programming, plotting, and so on.
* Sometimes the teacher may insist your answer is of the correct type. There are lots of types of mathematical objects, such as

  * equations: `3*x=x^2-1`. These need an equals sign!
  * inequalities: `x<=1`.
  * sets: `{1,2,3}`. Sets must be in curly brackets.
  * lists: `[1,1,2,3]`. List must be in square brackets.
  * matrices.  `matrix([1,2],[3,3])`.

Think about the form your answer should have before you type it in.

* Sometimes the teacher may not let you type in certain strings for educational reasons.
* Sometimes the teacher may not permit you to use floating point numbers, e.g. \(0.33\).
  In this case you should give an exact answer as, e.g. a fraction: `1/2` or a surd: `sqrt(2)`.
* Some expressions make no mathematical sense at all, e.g. one divided by zero. These are also invalid.

## What are _mathematical properties_? ##

When your answers are all valid you submit them again. This time they are assessed.
The outcomes are a mark, and sometimes some written feedback. If you did not obtain full marks
then you should try the question again.

Assessing your answer is not often a simple case of _correct_ or _incorrect_.
Often we might want your answer to satisfy a number of different mathematical properties. For example:

* If your expression algebraically equivalent to the correct expression?
* Is your expression fully simplified (e.g. have you gathered all like terms or factored your expression)?
* does your expression _satisfy the equation_?
* Is every element of your set a solution? Does your set of solutions contain them all?

Answering the question is all about thinking about what properties your answer should have!
If you are unsure then you need to ask the teacher.
