# Deploying

Questions in STACK can contain [randomly generated](../CAS/Random.md) elements.  A student will be given a random _variant_ of a question generated by a pseudo-random seed.

It is best if questions are not randomly generated on the fly.  Instead the teacher is strongly advised to pre-generate and "deploy" variants of a question.  When a student attempts the question they will be given a random selection from the deployed variants.

We have chosen to add the extra deploy step, instead of generating on the fly, for a number of reasons.

1. STACK runs all the question tests on each deployed variant to establish each variant of the question is working. This aids quality control. By using question tests it is unlikely a student will be given a random variant which does not work correctly.
2. The teacher can decide if each deployed variant appears to be of equal difficulty.  The teacher can easily delete variants they do not like.  Experience suggests there are unanticipated consequences of randomly generating questions.  Really only statistics generated by real use can establish fairness amongst variants.
3. The pre-generation combined with a cache helps minimise server load during the start of a large class which aids robustness of the whole experience.  This helps STACK to optimize its use of the CAS for efficiency and reliability via a dynamic cache.

Notes:

1. If an author does not deploy any variants (not advised!) then the student gets _any_ random variant.
2. Questions that don't use randomization cannot be deployed explicitly.  STACK automatically detects randomization.
3. Variants are different if and only if the evaluated [question note](../Authoring/Question_note.md) is different. Any number of instances can be requested and deployed but only one instance of each [question note](../Authoring/Question_note.md) can be deployed.  It is possible to deploy \(n\) variants in one go, but the system will give up if too many duplicate question notes are generated.  The teacher is responsible to ensure question variants are different if and only if the question notes are different.  The deployment management also allows specific variants to be dropped.  You can also return to the question preview window and try a specific deployed variant.
4. Deployment is not required for authors to test questions: an instance is generated on-the-fly.
5. Once a quiz is underway it is still possible in Moodle to edit a question, and to re-grade students' attempts.  This is useful in rare cases where there is a mistake, you want to improve the worked solution, you would like to add better feedback/partial credit for a particular etc.  However, do not change anything related to the random generation of questions!  Results are unpredictable, and may well result in a situation when the modified question is different to that answered by students taking the test prior to modifications...
6. It is possible to [systematically deploy](Deploying_systematically.md) all variants of a question in a simple manner.

## How to deploy question variants ##

The deployment interface can be found by editing a question and clicking on `question tests and deployed variants.` This link can also be found in the top right corner when previewing a question. This page contains the list of currently deployed variants, and links to un-deploy a variant.

Notes:

1. You can click on the seed numbers to view a particular random variant.  The testing page lists values of all the variables, displays the question and the worked solution.  The testing page is a very efficient way to look at your random variants.
2. When you deploy new variants STACK will run all the question tests.  If a test fails, the generation process will stop with an error message, showing the failing test.

## Systematic and matched variants

1. It is possible to [deploy all variants systematically](Deploying_systematically.md).
2. It is possible to [match variants between separate questions](Deploying_matched_variants.md).

These are advanced features.
