/**
 * A javascript module to handle separation of author sourced scripts into
 * IFRAMES. All such scripts will have limited access to the actual document
 * on the VLE side and this script represents the VLE side endpoint for
 * message handling needed to give that access. When porting STACK onto VLEs
 * one needs to map this script to do the following:
 *
 *  1. Ensure that searches for target elements/inputs are limited to questions
 *     or their feedback and do not return any elements outside them.
 *
 *  2. Map any identifiers needed to identify inputs by name.
 *
 *  3. Any change handling related to input value modifications through this
 *     logic gets connected to any such handling on the VLE side.
 *
 *
 * This script is intenttionally ordered so that the VLE specific bits should
 * be at the top.
 *
 *
 * This script assumes the following:
 *
 *  1. Each relevant IFRAME has an `id`-attribute that will be told to this
 *     script.
 *
 *  2. Each such IFRAME exists within the question content itself, so that
 *     one can traverse up the DOM tree from that IFRAME to find the border of
 *     the question.
 *
 * @module     qtype_stack/stackjsvle
 * @copyright  2023 Aalto University
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("qtype_stack/stackjsvle",["core_filters/events"],(function(CustomEvents){let IFRAMES={},INPUTS={},INPUTS_INPUT_EVENT={},DISABLE_CHANGES=!1;function vle_get_element(id){let candidate=document.getElementById(id),iter=candidate;for(;iter&&!iter.classList.contains("formulation")&&!iter.classList.contains("outcome");)iter=iter.parentElement;return iter&&(iter.classList.contains("formulation")||iter.classList.contains("outcome"))?candidate:null}function vle_get_input_element(name,srciframe,outside){void 0===outside&&(outside=!0);let iter=document.getElementById(srciframe);for(;iter&&!iter.classList.contains("formulation")&&!iter.classList.contains("outcome");)iter=iter.parentElement;if(iter&&(iter.classList.contains("formulation")||iter.classList.contains("outcome"))){let possible=iter.querySelector('input[id$="_'+name+'"]');if(null!==possible)return possible;if(possible=iter.querySelector('textarea[id$="_'+name+'"]'),null!==possible)return possible;if(possible=iter.querySelector('input[id$="_'+name+'_1"][type=radio]'),null!==possible)return possible;if(possible=iter.querySelector('input[id$="_'+name+'_1"][type=checkbox]'),null!==possible)return possible;if(possible=iter.querySelector('select[id$="_'+name+'"]'),null!==possible)return possible}if(!outside)return null;let possible=document.querySelector('.formulation input[id$="_'+name+'"]');return null!==possible?possible:(possible=document.querySelector('.formulation textarea[id$="_'+name+'"]'),null!==possible?possible:(possible=document.querySelector('.formulation input[id$="_'+name+'_1"][type=radio]'),null!==possible?possible:(possible=document.querySelector('.formulation input[id$="_'+name+'_1"][type=checkbox]'),null!==possible?possible:(possible=document.querySelector('.formulation select[id$="_'+name+'"]'),null!==possible?possible:(possible=document.querySelector('.outcome input[id$="_'+name+'"]'),null!==possible?possible:(possible=document.querySelector('.outcome textarea[id$="_'+name+'"]'),null!==possible||(possible=document.querySelector('.outcome select[id$="_'+name+'"]')),possible))))))}function vle_get_others_of_same_input_group(input){return"radio"===input.type?document.querySelectorAll(".formulation input[name="+CSS.escape(input.name)+"]"):input.name.startsWith("q")&&input.name.indexOf(":")>-1&&input.name.endsWith("_1")?document.querySelectorAll(".formulation input[name^="+CSS.escape(input.name.substring(0,input.name.length-1))+"]"):document.querySelectorAll(".formulation input[name="+CSS.escape(input.name)+"]")}function vle_get_submit_button(srciframe){let iter=document.getElementById(srciframe);for(;iter&&!iter.classList.contains("formulation");)iter=iter.parentElement;if(iter&&iter.classList.contains("formulation")){return iter.querySelector('.im-controls *[id$="-submit"][type=submit]')}return null}function vle_update_input(inputelement){const c=new Event("change");inputelement.dispatchEvent(c);const i=new Event("input");if(inputelement.dispatchEvent(i),"radio"===inputelement.type||"checkbox"===inputelement.type){const k=new Event("click");inputelement.dispatchEvent(k)}}function vle_update_dom(modifiedsubtreerootelement){CustomEvents.notifyFilterContentUpdated(modifiedsubtreerootelement)}function is_evil_attribute(name,value){const lcname=name.toLowerCase();if(lcname.startsWith("on"))return!0;if("src"===lcname||lcname.endsWith("href")){const lcvalue=value.replace(/\s+/g,"").toLowerCase();if(lcvalue.includes("javascript:")||lcvalue.includes("data:text"))return!0}return!1}return window.addEventListener("message",(e=>{if(!("string"==typeof e.data||e.data instanceof String))return;let msg=null;try{msg=JSON.parse(e.data)}catch(e){return}if(!("version"in msg)||!msg.version.startsWith("STACK-JS"))return;if(!("src"in msg&&"type"in msg&&msg.src in IFRAMES))return;let element=null,input=null,response={version:"STACK-JS:1.4.0"};switch(msg.type){case"register-input-listener":if(input=vle_get_input_element(msg.name,msg.src,!msg["limit-to-question"]),null===input)return response.type="error",response.msg='Failed to connect to input: "'+msg.name+'"',response.tgt=msg.src,void IFRAMES[msg.src].contentWindow.postMessage(JSON.stringify(response),"*");if(response.type="initial-input",response.name=msg.name,response.tgt=msg.src,"select"===input.nodeName.toLowerCase()?(response.value=input.value,response["input-type"]="select",response["input-readonly"]=input.hasAttribute("disabled")):"textarea"===input.nodeName.toLowerCase()?(response.value=input.value,response["input-type"]="textarea",response["input-readonly"]=input.hasAttribute("disabled")):"checkbox"===input.type?(response.value=input.checked,response["input-type"]="checkbox",response["input-readonly"]=input.hasAttribute("disabled")):(response.value=input.value,response["input-type"]=input.type,response["input-readonly"]=input.hasAttribute("readonly")),"radio"===input.type){response["input-readonly"]=input.hasAttribute("disabled"),response.value="";for(let inp of document.querySelectorAll("input[type=radio][name="+CSS.escape(input.name)+"]"))inp.checked&&(response.value=inp.value)}for(var k in response["input-dataset"]={},input.dataset)response["input-dataset"][k]=input.dataset[k];if(input.id in INPUTS){if(msg.src in INPUTS[input.id])return;if("radio"!==input.type)INPUTS[input.id].push(msg.src);else{let radgroup=document.querySelectorAll("input[type=radio][name="+CSS.escape(input.name)+"]");for(let inp of radgroup)INPUTS[inp.id].push(msg.src)}}else{if("radio"!==input.type)INPUTS[input.id]=[msg.src];else{let radgroup=document.querySelectorAll("input[type=radio][name="+CSS.escape(input.name)+"]");for(let inp of radgroup)INPUTS[inp.id]=[msg.src]}if("radio"!==input.type)input.addEventListener("change",(()=>{if(DISABLE_CHANGES)return;let resp={version:"STACK-JS:1.0.0",type:"changed-input",name:msg.name};"checkbox"===input.type?resp.value=input.checked:resp.value=input.value;for(let tgt of INPUTS[input.id])resp.tgt=tgt,IFRAMES[tgt].contentWindow.postMessage(JSON.stringify(resp),"*")}));else{document.querySelectorAll("input[type=radio][name="+CSS.escape(input.name)+"]").forEach((inp=>{inp.addEventListener("change",(()=>{if(DISABLE_CHANGES)return;let resp={version:"STACK-JS:1.0.0",type:"changed-input",name:msg.name};if(inp.checked){resp.value=inp.value;for(let tgt of INPUTS[inp.id])resp.tgt=tgt,IFRAMES[tgt].contentWindow.postMessage(JSON.stringify(resp),"*")}}))}))}}if("track-input"in msg&&msg["track-input"]&&"radio"!==input.type)if(input.id in INPUTS_INPUT_EVENT){if(msg.src in INPUTS_INPUT_EVENT[input.id])return;INPUTS_INPUT_EVENT[input.id].push(msg.src)}else INPUTS_INPUT_EVENT[input.id]=[msg.src],input.addEventListener("input",(()=>{if(DISABLE_CHANGES)return;let resp={version:"STACK-JS:1.0.0",type:"changed-input",name:msg.name};"checkbox"===input.type?resp.value=input.checked:resp.value=input.value;for(let tgt of INPUTS_INPUT_EVENT[input.id])resp.tgt=tgt,IFRAMES[tgt].contentWindow.postMessage(JSON.stringify(resp),"*")}));msg.src in INPUTS[input.id]||IFRAMES[msg.src].contentWindow.postMessage(JSON.stringify(response),"*");break;case"changed-input":if(input=vle_get_input_element(msg.name,msg.src),null===input){const ret={version:"STACK-JS:1.0.0",type:"error",msg:'Failed to modify input: "'+msg.name+'"',tgt:msg.src};return void IFRAMES[msg.src].contentWindow.postMessage(JSON.stringify(ret),"*")}DISABLE_CHANGES=!0,"checkbox"===input.type?input.checked=msg.value:input.value=msg.value,vle_update_input(input),DISABLE_CHANGES=!1,response.type="changed-input",response.name=msg.name,response.value=msg.value;for(let tgt of INPUTS[input.id])tgt!==msg.src&&(response.tgt=tgt,IFRAMES[tgt].contentWindow.postMessage(JSON.stringify(response),"*"));break;case"clear-input":if(input=vle_get_input_element(msg.name,msg.src),"select"===input.nodeName.toLowerCase()){-1!==input.selectedIndex&&(input.selectedIndex=-1,vle_update_input(input));for(var i=0;i<input.options.length;i++)input.options[i].hasAttribute("selected")&&(input.options[i].removeAttribute("selected"),vle_update_input(input)),""===input.options[i].value&&(input.options[i].selected=!0,vle_update_input(input))}else if("textarea"===input.nodeName.toLowerCase())""!==input.value&&(input.value="",vle_update_input(input));else if("checkbox"===input.type)for(let inp of vle_get_others_of_same_input_group(input))inp.checked=!1,vle_update_input(inp);else if("radio"===input.type)for(let inp of vle_get_others_of_same_input_group(input))inp.checked=""===inp.value,vle_update_input(inp);else""!==input.value&&(input.value="",vle_update_input(input));vle_update_input(input);break;case"register-button-listener":if(element=vle_get_element(msg.target),null===element){const ret={version:"STACK-JS:1.2.0",type:"error",msg:'Failed to find element: "'+msg.target+'"',tgt:msg.src};return void IFRAMES[msg.src].contentWindow.postMessage(JSON.stringify(ret),"*")}element.addEventListener("click",(event=>{let resp={version:"STACK-JS:1.2.0",type:"button-click",name:msg.target,tgt:msg.src};IFRAMES[msg.src].contentWindow.postMessage(JSON.stringify(resp),"*"),event.preventDefault()}));break;case"toggle-visibility":if(element=vle_get_element(msg.target),null===element){const ret={version:"STACK-JS:1.0.0",type:"error",msg:'Failed to find element: "'+msg.target+'"',tgt:msg.src};return void IFRAMES[msg.src].contentWindow.postMessage(JSON.stringify(ret),"*")}"show"===msg.set?(element.style.display="block",vle_update_dom(element)):"hide"===msg.set&&(element.style.display="none");break;case"change-content":if(element=vle_get_element(msg.target),null===element)return response.type="error",response.msg='Failed to find element: "'+msg.target+'"',response.tgt=msg.src,void IFRAMES[msg.src].contentWindow.postMessage(JSON.stringify(response),"*");element.innerHTML=function(src){let doc=(new DOMParser).parseFromString(src,"text/html");for(let el of doc.querySelectorAll("script, style"))el.remove();for(let el of doc.querySelectorAll("*"))for(let{name:name,value:value}of el.attributes)is_evil_attribute(name,value)&&el.removeAttribute(name);return doc.body}(msg.content).innerHTML,vle_update_dom(element);break;case"get-content":element=vle_get_element(msg.target),response.type="xfer-content",response.tgt=msg.src,response.target=msg.target,response.content=null,null!==element&&(response.content=element.innerHTML),IFRAMES[msg.src].contentWindow.postMessage(JSON.stringify(response),"*");break;case"resize-frame":element=IFRAMES[msg.src].parentElement,element.style.width=msg.width,element.style.height=msg.height,IFRAMES[msg.src].style.width="100%",IFRAMES[msg.src].style.height="100%",vle_update_dom(element);break;case"ping":return response.type="ping",response.tgt=msg.src,void IFRAMES[msg.src].contentWindow.postMessage(JSON.stringify(response),"*");case"query-submit-button":return response.type="submit-button-info",response.tgt=msg.src,input=vle_get_submit_button(msg.src),null===input||input.hasAttribute("hidden")?response.value=null:response.value=input.value,void IFRAMES[msg.src].contentWindow.postMessage(JSON.stringify(response),"*");case"enable-submit-button":return input=vle_get_submit_button(msg.src),void(null!==input?msg.enabled?input.removeAttribute("disabled"):input.disabled=!0:(response.type="error",response.msg="Could not find matching submit button for this question.",response.tgt=msg.src,IFRAMES[msg.src].contentWindow.postMessage(JSON.stringify(response),"*")));case"relabel-submit-button":return input=vle_get_submit_button(msg.src),void(null!==input?(input.childNodes.length>1?input.childNodes.forEach((n=>{"#text"==n.nodeName&&(n.textContent=msg.name)})):input.innerHTML=msg.name,input.value=msg.name):(response.type="error",response.msg="Could not find matching submit button for this question.",response.tgt=msg.src,IFRAMES[msg.src].contentWindow.postMessage(JSON.stringify(response),"*")));case"submit-button-info":case"initial-input":case"error":break;default:response.type="error",response.msg='Unknown message-type: "'+msg.type+'"',response.tgt=msg.src,IFRAMES[msg.src].contentWindow.postMessage(JSON.stringify(response),"*")}})),{create_iframe(iframeid,content,targetdivid,title,scrolling,evil){const frm=document.createElement("iframe");frm.id=iframeid,frm.style.width="100%",frm.style.height="100%",frm.style.border=0,!1===scrolling?(frm.scrolling="no",frm.style.overflow="hidden"):frm.scrolling="yes",frm.title=title,frm.referrerpolicy="no-referrer",evil||(frm.sandbox="allow-scripts allow-downloads"),frm.srcdoc=content,document.getElementById(targetdivid).replaceChildren(frm),IFRAMES[iframeid]=frm}}}));

//# sourceMappingURL=stackjsvle.min.js.map