# Tidy Tool

STACK potential response trees, and other parts of questions, can easily get messy. You may have one long question and delete some inputs, or duplicate a question and use it as a template but have to heavily edit it. Another example is to add nodes in an existing PRT and place these nodes between existing nodes. The numbering won't be in order and it will make it harder to follow the PRT logic.

In STACK, there is a "tidy tool" that can help with resolving these annoying issues. 

You can find the tool under the "STACK question dashboard" -> "Tidy inputs and PRTs"

This opens a page where you can see the preview of the question, the name of each input and the Feedback that corresponds to each specific input.  You have the options to change the name of each Input, the name of each PRT (feedback option) and the name of each node in each individual PRT. 

Here are 2 examples to demonstrate this feature. 

## A question with 1 input and messy nodes in the PRT
	
The tool suggests the new names for the nodes so they will appear in arithmetic order. 

![A messy PRT](../../content/PRT_messy.png)
	
Go back into the question and you can see the change at the nodes of the PRT.
	
![A tidy PRT](../../content/PRT_tidy.png)

## A question with messy input names
	
The question has five inputs but because some inputs were removed, the names of the inputs are not in order. You need to type the new names of the inputs and PRTs.

![A tidy PRT](../../content/Tidy_inputs.png)

