# 問題作成クイック・スタート・ガイド4：ランダム化
[1 - 基本的な問題](Authoring_quick_start_1.md) | [2 - 問題変数](Authoring_quick_start_2.md) | [3 - フィードバックを改善する](Authoring_quick_start_3.md) | 4 - ランダム化 | [5 - 問題のテスト](Authoring_quick_start_5.md) | [6 - 複数回答欄問題](Authoring_quick_start_6.md) | [7 - 数式簡略の無効化](Authoring_quick_start_7.md) | [8 - 問題のインポートと小テスト](Authoring_quick_start_8.md)


問題作成クイックスタートガイドのこのパートでは,問題をランダムに出題する方法について説明します。 次のビデオでその方法について説明しています:

<iframe width="560" height="315" src="https://www.youtube.com/embed/8FTqZ1fTmgs" frameborder="0" allowfullscreen></iframe>
## はじめに

前のパートでは,\(3(x-1)^{-4}\)を\(x\)について積分する方法を学びました。しかし，学生間での解答共有を避けるため,このようなシステムですべての学生に全く同じ問題を出題することは避けたいです。この課題を解決するため,問題をランダムに出題することが必要です。

## 問題をランダムに出題する

先ほどの問題の変数をもう一度確認しましょう:

```
exp: 3*(x-1)^(-4);
ta: int(exp,x)+c;
```

私たちは2つの ローカル変数 `exp` と `ta`を定義し, 問題テキスト,入力,ポテンシャル・レスポンス・ツリーなどの他の場所でこれらの値を使用しました。

では，今からランダムな問題を作成しましょう。そのために, [問題変数](../../en/Authoring/Variables.md#Question_variables) を次のように設定します。

```
a1 : 1+rand(6);
a2 : 1+rand(6);
nn : 1+rand(4);
exp : a1*(x-a2)^(-nn);
ta: int(exp, x)+c;
```

この新たな問題で,私たちは生徒に,\( a_1(x-a_2)^{-nn} \)の積分を求めてもらいます。 `a1`, `a2` , `nn` はすべてランダムな正の整数が代入された変数です。 これらは問題で利用される変数 `exp`を定義するために使われます。また,CASに式 `exp` を積分させ,その結果を変数 `ta` に格納します。xのような1文字の変数は生徒の入力を意味するため、問題作成時に定義する変数には2文字以上利用することを推奨します。

STACKでランダムに出題される問題を作成するとき,私たちは_乱数_を扱いますが,本当は_擬似乱数_であることを覚えておいてください。どの乱数が各ユーザーのために生成されたかを追跡するために,STACKには特別な `rand` コマンドがあり,[Maxima](../../en/CAS/Maxima.md) の `random` コマンドの代わりに使用する必要があります。 `rand` コマンドは一般的な「ランダムなもの」を生成します。詳しくは[ランダム生成](../../en/CAS/Random.md) をご覧ください。`rand` は乱数を生成するだけでなく、リストから選ぶことにも使用できます。 `rand(n)`は0以上`n`未満の整数をランダムに選択します。 つまり、 `rand(3)` と入力した場合、リスト`[0,1,2]`からランダムに選択することになります .

## 問題記録

問題に乱数が含まれる場合,各学生に出題された問題のバージョンを記録する必要があります。`rand` 関数を利用した場合,STACK は必ず __問題記録__ を利用するように要求してきます。 
問題記録 を次のように入力してください

```
\[ \int {@exp@} \mathrm{d}x = {@ta@}.\]
```

2つの問題は問題記録が完全に一致する場合のみ同じ問題であるとみなされます。問題作成者は問題記録を正確に設定するよう気を付けてください。

## ランダムな問題のデプロイ

学生が問題を見る前に,ランダムな問題をデプロイすることは賢明です。これにより,学生に表示される問題を適切に制御し,ランダム化が正常に行われていることを確認できます。問題を保存した後，問題の一番上までスクロールし,`この問題では変形がデプロイされていません` というリンクをクリックしてください。 このリンクは、古いバージョンのSTACKでは `問題のテストとデプロイ` と表示されるかもしれません。

STACKでたくさんのランダムな問題を作成するには,`次の個数の変形をデプロイする`を実行することが必要です。例えば,`10`を入力し,`次の個数の変形をデプロイする`をクリックしてください。 すると10個のランダムな問題が表示されるはずです。学生にはこれらのうち1つがランダムに表示されます。

また,利用したくない変形を削除するオプションもあります。例えば、nn=1 の変数は対数を含む答えがあるので利用したくないと考える場合もあります。この場合,利用したくない変数を選択的に削除することができます。ところでこの場合のよりよい解決策は,`問題変数`に戻って,`nn`を`2+rand(4)`に変更することです。保存後に `次の個数の変形をデプロイする` に戻ると、変形が変更されているのがわかるでしょう。これは乱数を利用する際の重要なポイントである,ランダム化の意図しない結果をチェックする方法を示しています。

## プレビュー

問題をプレビューしてみてください。クイックスタートガイドのパート1で述べたように、`プレビューオプション`の下に、問題動作を変更するオプションがあります。`アダプティブモード`は問題を繰り返し`確認`することができるため，問題をテストする際に最も便利なモードです。問題動作については後で詳しく説明します。

ここで、デプロイされたどの `変形` を解答するかを選択できることに注意してください。これは特定の変形をテストしたい場合に便利です。


# 次へ #

これでSTACKでランダムな問題を作成,出題することができるようになりました。

##### オーサリングクイックスタートガイドの次の章では,[問題のテスト](Authoring_quick_start_5.md)について説明します。