# Sample Questions

STACK is distributed with sample questions in

     /qtype_stack/samplequestions

The sample questions are in English.

# STACK library {#STACK_library} # 

This is a collection of individual question files which can be imported via the STACK library page. Begin creating a new STACK question in your required question category. On the question edit form, rather than entering question data, click on the 'STACK question library' link. You can then browse and import questions.

The questions are contained in

     /qtype_stack/samplequestions/stacklibrary

This directory contains sub-directories with large libraries of questions:

* `Algebra-Refresher` contains questions to cover all parts of the [The Map of Algebraic Manipulation](http://www.mth.kcl.ac.uk/staff/ad_barnard/Pocket.pdf).
* `Calculus-Refresher` contains questions to cover all of the [Calculus Refresher](https://docs.stack-assessment.org/content/final0502-calc-ref-ukmlsc.pdf) by Dr Tony Croft and Dr Anthony Kay.
* `General-maths-questions` contains questions in a variety of other topics.
* `Doc-Examples` contains questions linked to documentation pages.  These are not intended as exemplar questions!  (They may be incomplete, and illustrate a starting point for an exercise for question authors to complete.)
* `Topics` contains questions linked to the [mathematical topics](../Topics/index.md) using a matching naming/directory structure.

We would encourage colleagues to release their materials under a creative commons licence.  Please contact the developers.

A significant advantage of using questions from the STACK library is that they are distributed with the source code, and therefore use features which match your version of STACK.

# Moodle courses released with STACK #

STACK is released with a demonstration course which contains hundreds of tested STACK questions.  Many have a full worked solution and random variants, and this represents a substantial resource.

     /qtype_stack/samplequestions/STACK-demo.mbz

We have also release a course containing all the HELM materials, which are comprhensive courses in engineering mathematics.

You can "restore" these into your version of Moodle.  It has a number of quizzes, pre-created with questions and deployed variants.  It also has a large question bank, with questions not arranged into quizzes.

# Open Educational Resources #

* The FETLAR project released a large collection of STACK questions in English covering calculus and algebra in April 2010.  These are now part of the [demonstration course](https://stack2.maths.ed.ac.uk/demo2018/).
* Abacus is a material bank for STEM education which seeks to produce, share and host high-quality educational material between collaborators.  For more information see [https://abacus.aalto.fi/](https://abacus.aalto.fi/)


