/**
 * A javascript module to handle the real-time validation of the input the student types
 * into STACK questions.
 *
 * The overall way this works is as follows:
 *
 *  - right at the end of this file are the init methods, which set things up.
 *  - The work common to all input types is done by StackInput.
 *     - Sending the Ajax request.
 *     - Updating the validation display.
 *  - The work specific to different input types (getting the content of the inputs) is done by
 *    the classes like
 *     - StackSimpleInput
 *     - StackTextareaInput
 *     - StackMatrixInput
 *    objects of these types need to implement the two methods addEventHandlers and getValue().
 *
 * @module     qtype_stack/input
 * @copyright  2018 The Open University
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("qtype_stack/input",["core/ajax","core_filters/events"],(function(Ajax,CustomEvents){function StackInput(validationDiv,prefix,qaid,name,input,language,validationsInProgress){var TYPING_DELAY=1e3,delayTimeoutHandle=null,validationResults={},lastValidatedValue=getInputValue(),checkButton=document.getElementById(prefix+"-submit");function cancelTypingDelay(){delayTimeoutHandle&&clearTimeout(delayTimeoutHandle),delayTimeoutHandle=null}function valueChanging(){cancelTypingDelay(),showWaiting(),delayTimeoutHandle=setTimeout(valueChanged,TYPING_DELAY),setTimeout((function(){checkNoChange()}),0)}function checkNoChange(){getInputValue()===lastValidatedValue&&(cancelTypingDelay(),validationDiv.classList.remove("waiting"),checkButton&&(validationsInProgress.delete(name),0===validationsInProgress.size&&(checkButton.disabled=!1)))}function valueChanged(){cancelTypingDelay(),showValidationResults()||validateInput()}function validateInput(){Ajax.call([{methodname:"qtype_stack_validate_input",args:{qaid:qaid,name:name,input:getInputValue(),lang:language},done:function(response){validationReceived(response)},fail:function(response){showValidationFailure(response)}}]),showLoading()}function getInputValue(){return input.getValue()}function validationReceived(response){"invalid"!==response.status?(validationResults[response.input]=response,showValidationResults()):showValidationFailure(response)}function extractScripts(html,scriptCommands){for(var result,scriptregexp=/<script[^>]*>([\s\S]*?)<\/script>/g;null!==(result=scriptregexp.exec(html));)scriptCommands.push(result[1]);return html.replace(scriptregexp,"")}function showValidationResults(){var val=getInputValue();if(!validationResults[val])return showWaiting(),!1;var results=validationResults[val];lastValidatedValue=val;var scriptCommands=[];validationDiv.innerHTML=extractScripts(results.message,scriptCommands);for(var i=0;i<scriptCommands.length;i++)eval(scriptCommands[i]);return removeAllClasses(),results.message||validationDiv.classList.add("empty"),CustomEvents.notifyFilterContentUpdated(validationDiv),!0}function showValidationFailure(response){lastValidatedValue="",validationDiv.innerHTML=response.message,removeAllClasses(),validationDiv.classList.add("error"),CustomEvents.notifyFilterContentUpdated(validationDiv)}function showLoading(){removeAllClasses(),validationDiv.classList.add("loading")}function showWaiting(){removeAllClasses(),validationDiv.classList.add("waiting"),checkButton&&(validationsInProgress.add(name),checkButton.disabled=!0)}function removeAllClasses(){validationDiv.classList.remove("empty"),validationDiv.classList.remove("error"),validationDiv.classList.remove("loading"),validationDiv.classList.remove("waiting"),checkButton&&(validationsInProgress.delete(name),0===validationsInProgress.size&&(checkButton.disabled=!1))}input.addEventHandlers(valueChanging)}function StackSimpleInput(input){this.addEventHandlers=function(valueChanging){input.addEventListener("input",valueChanging)},this.getValue=function(){return input.value.replace(/^\s+|\s+$/g,"")}}function StackTextareaInput(textarea){this.addEventHandlers=function(valueChanging){textarea.addEventListener("input",valueChanging)},this.getValue=function(){return textarea.value.replace(/^\s+|\s+$/g,"").split(/\s*[\r\n]\s*/).join("<br>")}}function StackRadioInput(container){this.addEventHandlers=function(valueChanging){container.addEventListener("input",valueChanging)},this.getValue=function(){var selected=container.querySelector(":checked");return selected?selected.value:""}}function StackCheckboxInput(container){this.addEventHandlers=function(valueChanging){container.addEventListener("input",valueChanging)},this.getValue=function(){for(var selected=container.querySelectorAll(":checked"),result=[],i=0;i<selected.length;i++)result[i]=selected[i].value;return result.length>0?result.join(","):""}}function StackMatrixInput(idPrefix,container){var numcol=0,numrow=0;container.querySelectorAll("input[type=text]").forEach((function(element){if(element.name.slice(0,idPrefix.length+5)===idPrefix+"_sub_"){var bits=element.name.substring(idPrefix.length+5).split("_");numrow=Math.max(numrow,parseInt(bits[0],10)+1),numcol=Math.max(numcol,parseInt(bits[1],10)+1)}})),this.addEventHandlers=function(valueChanging){container.addEventListener("input",valueChanging)},this.getValue=function(){for(var values=new Array(numrow),i=0;i<numrow;i++)values[i]=new Array(numcol);return container.querySelectorAll("input[type=text]").forEach((function(element){if(element.name.slice(0,idPrefix.length+5)===idPrefix+"_sub_"){var bits=element.name.substring(idPrefix.length+5).split("_");values[bits[0]][bits[1]]=element.value.replace(/^\s+|\s+$/g,"")}})),JSON.stringify(values)}}function initInputs(questionDivId,prefix,qaid,inputs){var questionDiv=document.getElementById(questionDivId),validationsInProgress=new Set,language=null,langInput=document.getElementsByName(prefix+"step_lang");langInput.length>0&&langInput[0].value&&(language=langInput[0].value);for(var allok=!0,i=0;i<inputs.length;i++)allok=initInput(questionDiv,prefix,qaid,inputs[i],language,validationsInProgress)&&allok;if(allok&&(questionDiv.classList.contains("dfexplicitvaildate")||questionDiv.classList.contains("dfcbmexplicitvaildate"))){const input=questionDiv.querySelector(".im-controls input.submit, .im-controls button.submit");input&&(input.hidden=!0)}}function initInput(questionDiv,prefix,qaid,name,language,validationsInProgress){var validationDiv=document.getElementById(prefix+name+"_val");if(!validationDiv)return!1;var inputTypeHandler=getInputTypeHandler(questionDiv,prefix,name);return!!inputTypeHandler&&(new StackInput(validationDiv,prefix,qaid,name,inputTypeHandler,language,validationsInProgress),!0)}function getInputTypeHandler(questionDiv,prefix,name){var input=questionDiv.querySelector('[name="'+prefix+name+'"]');if(input)return"TEXTAREA"===input.nodeName?new StackTextareaInput(input):"radio"===input.type?new StackRadioInput(input.closest(".answer")):new StackSimpleInput(input);if((input=questionDiv.querySelector('[name="'+prefix+name+'_1"]'))&&"checkbox"===input.type)return new StackCheckboxInput(input.closest(".answer"));var matrix=document.getElementById(prefix+name+"_container");return matrix?new StackMatrixInput(prefix+name,matrix):null}return{initInputs:initInputs}}));

//# sourceMappingURL=input.min.js.map