package approach3.window;

import approach3.misc.MapLoader;
import approach3.parallel.SharedRessources;
import approach3.parallel.WallBasedPathfinder;
import framework.Game;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class MainWindowApproach3 extends Game {
    public MainWindowApproach3(String title, int w, int h) {
        super(title, w, h);
    }


    public static final int SIZE = 1;

    private WallBasedPathfinder pathfinder;
    private ArrayList<Point> foundPath;

    private boolean pressed;


    @Override
    public void loadGame() {

        SharedRessources.getInstance().setMaxCores(2);
        SharedRessources.getInstance()
                .setCurrentProfile(SharedRessources.Profile.BEST_NODES);

        try {
            MapLoader.getDefault().load(ImageIO.read(new File("examples/maze3.png")));
        } catch (IOException e) {
            e.printStackTrace();
        }

        pathfinder = new WallBasedPathfinder();


    }

    @Override
    public void updateGame() {

        if (isMouseKeyDown(MouseEvent.BUTTON1))
            SharedRessources.getInstance().setStart(this.getMouseX() / SIZE, this.getMouseY() / SIZE);

        if (isMouseKeyDown(MouseEvent.BUTTON3))
            SharedRessources.getInstance().setEnd(this.getMouseX() / SIZE, this.getMouseY() / SIZE);

        if (isKeyDown(KeyEvent.VK_ENTER) && !pressed) {


            SharedRessources
                    .getInstance()
                    .setStart(12, 38);

            SharedRessources
                    .getInstance()
                    .setEnd(793, 741);

            System.out.println("BEGIN: " + SharedRessources.getInstance().getStart());
            System.out.println("END: " + SharedRessources.getInstance().getEnd());


            pressed = true;
            pathfinder.find();


            SharedRessources
                    .getInstance().getExecutor()
                    .execute(new Runnable() {
                        @Override
                        public void run() {
                            while (!SharedRessources.getInstance().isFound()) ;

                            int beginX = SharedRessources.getInstance().getStart().x;
                            int beginY = SharedRessources.getInstance().getStart().y;

                            int endX = SharedRessources.getInstance().getEnd().x;
                            int endY = SharedRessources.getInstance().getEnd().y;


                            foundPath = pathfinder.calculatePath(beginX, beginY, endX, endY);
                        }
                    });


        }

        if (isKeyUp(KeyEvent.VK_ENTER))
            pressed = false;


    }

    @Override
    public void renderGame(Graphics g) {
        if (pathfinder == null)
            return;

        pathfinder.draw(g, false);

        if (foundPath == null)
            return;



    }
}
