package approach3.parallel.operations;

import approach3.parallel.SharedRessources;

import java.awt.*;
import java.util.ArrayDeque;
import java.util.Queue;

/**
 * Diese Klasse überflutet alle Bereiche an der Wand und probiert an jedem Punkt eine
 * neue Trace zum Ziel zu generieren
 */
public class Flood implements Runnable {

    private int px;
    private int py;

    private int steps;

    private Queue<Point> openPoints
            = new ArrayDeque<>();

    public Flood(int x, int y, int steps) {
        this.px = x;
        this.py = y;
        this.steps = steps;
    }


    @Override
    public void run() {
        if (SharedRessources.getInstance().isWall(px, py))
            return;

        openPoints.offer(new Point(px, py));

        while (!openPoints.isEmpty() && !SharedRessources.getInstance().isFound()) {

            Point cur
                    = openPoints.poll();


            int x = cur.x;
            int y = cur.y;


            boolean
                    left = SharedRessources.getInstance().isWall(x - 1, y);
            boolean
                    right = SharedRessources.getInstance().isWall(x + 1, y);
            boolean up
                    = SharedRessources.getInstance().isWall(x, y - 1);
            boolean down
                    = SharedRessources.getInstance().isWall(x, y + 1);

            boolean leftUp =
                    SharedRessources.getInstance().isWall(x - 1, y - 1);
            boolean rightUp =
                    SharedRessources.getInstance().isWall(x + 1, y - 1);
            boolean leftDown =
                    SharedRessources.getInstance().isWall(x - 1, y + 1);
            boolean rightDown =
                    SharedRessources.getInstance().isWall(x + 1, y + 1);


            int stepLeft
                    = SharedRessources.getInstance().getStep(x - 1, y);
            int stepRight
                    = SharedRessources.getInstance().getStep(x + 1, y);
            int stepUp
                    = SharedRessources.getInstance().getStep(x, y - 1);
            int stepDown
                    = SharedRessources.getInstance().getStep(x, y + 1);

            if (!left && !right && !up && !down && !rightDown && !rightUp && !leftDown && !leftUp)
                continue;

            if (!left) {
                if (steps < stepLeft) {
                    SharedRessources.getInstance()
                            .setData(x - 1, y, 1, 0, steps + 1);

                    openPoints
                            .offer(new Point(x - 1, y));

                }
            }

            if (!right) {
                if (steps < stepRight) {
                    SharedRessources.getInstance()
                            .setData(x + 1, y, -1, 0, steps + 1);


                    openPoints
                            .offer(new Point(x + 1, y));
                }
            }

            if (!up) {
                if (steps < stepUp) {
                    SharedRessources.getInstance()
                            .setData(x, y - 1, 0, 1, steps + 1);


                    openPoints
                            .offer(new Point(x, y - 1));
                }
            }

            if (!down) {
                if (steps < stepDown) {
                    SharedRessources.getInstance()
                            .setData(x, y + 1, 0, -1, steps + 1);


                    openPoints
                            .offer(new Point(x, y + 1));
                }
            }


            if (steps % SharedRessources.getInstance().getCurrentProfile().getValue() == 0)
                SharedRessources
                        .getInstance()
                        .getExecutor()
                        .execute(new Trace(
                                x,
                                y,
                                SharedRessources.getInstance().getStart().x,
                                SharedRessources.getInstance().getStart().y,
                                steps));

            steps++;

        }

        // System.out.println("[*] Done flooding.");


    }
}
