package approach3.parallel;

import approach3.misc.Lexicon;
import approach3.parallel.operations.Trace;
import approach3.window.MainWindowApproach3;
import structs.Int3;
import structs.Vec3;

import java.awt.*;
import java.util.ArrayList;

public class WallBasedPathfinder {


    public void find() {

        int beginX = SharedRessources.getInstance().getStart().x;
        int beginY = SharedRessources.getInstance().getStart().y;

        int endX = SharedRessources.getInstance().getEnd().x;
        int endY = SharedRessources.getInstance().getEnd().y;


        SharedRessources
                .getInstance()
                .getExecutor()
                .execute(new Trace(endX, endY, beginX, beginY, 0));


    }


    ArrayList<Point> path
            = new ArrayList<>();

    public ArrayList<Point> calculatePath(int startX, int startY, int destX, int destY) {


        int x = startX;
        int y = startY;

        while (x != destX || y != destY) {

            path.add(new Point(x, y));

            Int3 currentDir
                    =
                    SharedRessources.getInstance().getData(x, y);

            int dx = (int) currentDir.getX();
            int dy = (int) currentDir.getY();

            if (dx == 0 && dy == 0)
                break;


            // System.out.println(Lexicon.getInstance().getText(new Point(dx, dy)));
            x += dx;
            y += dy;

            /*
            try {
                Thread.sleep(1);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }

             */
        }

        System.out.println("Done tracing back.");

        return path;
    }


    public void draw(Graphics g, boolean showMeta) {
        for (int j = 0; j < SharedRessources.getInstance().getHeight(); j++) {
            for (int i = 0; i < SharedRessources.getInstance().getWidth(); i++) {
                if (SharedRessources.getInstance().isWall(i, j)) {
                    g.setColor(Color.blue);
                    g.fillRect(i * MainWindowApproach3.SIZE, j * MainWindowApproach3.SIZE,
                            MainWindowApproach3.SIZE, MainWindowApproach3.SIZE);
                } else if (SharedRessources.getInstance().getStep(i, j) != Integer.MAX_VALUE && showMeta) {
                    int dx =
                            (int) SharedRessources.getInstance().getData(i, j).getX() * MainWindowApproach3.SIZE;
                    int dy =
                            (int) SharedRessources.getInstance().getData(i, j).getY() * MainWindowApproach3.SIZE;

                    int green = SharedRessources.getInstance().getStep(i, j);
                    if (green >= 255)
                        green = 255;
                    Color color
                            = new Color(0, green, 0);

                    g.setColor(color);
                    g.fillRect(i * MainWindowApproach3.SIZE, j * MainWindowApproach3.SIZE,
                            MainWindowApproach3.SIZE, MainWindowApproach3.SIZE);


                    g.setColor(Color.red);
                    g.drawLine(
                            i * MainWindowApproach3.SIZE,
                            j * MainWindowApproach3.SIZE,
                            i * MainWindowApproach3.SIZE + dx,
                            j * MainWindowApproach3.SIZE + dy);


                } else {
                    g.setColor(Color.black);
                    g.fillRect(i * MainWindowApproach3.SIZE, j * MainWindowApproach3.SIZE,
                            MainWindowApproach3.SIZE, MainWindowApproach3.SIZE);
                }
            }

        }

        if (SharedRessources.getInstance().
                getEnd() == null || SharedRessources.getInstance().getStart() == null)
            return;


        g.setColor(Color.yellow);
        g.fillRect(
                SharedRessources.getInstance().getEnd().x * MainWindowApproach3.SIZE,
                SharedRessources.getInstance().getEnd().y * MainWindowApproach3.SIZE,
                MainWindowApproach3.SIZE, MainWindowApproach3.SIZE);

        g.setColor(Color.red);
        g.fillRect(
                SharedRessources.getInstance().getStart().x * MainWindowApproach3.SIZE,
                SharedRessources.getInstance().getStart().y * MainWindowApproach3.SIZE,
                MainWindowApproach3.SIZE, MainWindowApproach3.SIZE);

        g.setColor(Color.red);
        for (int i = 0; i < path.size(); i++) {
            var pt = path.get(i);
            g.fillRect(pt.x * MainWindowApproach3.SIZE, pt.y * MainWindowApproach3.SIZE, MainWindowApproach3.SIZE, MainWindowApproach3.SIZE);
        }
    }
}
