package approach3.parallel;

import structs.Int3;

import java.awt.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SharedRessources {
    private static final int AVAIBLE_CORES
            = Runtime.getRuntime().availableProcessors();

    public enum Profile {

        /***
         * Every iteration in flood a line to dest will be constructed
         * <br>Information: The path found can be optimal
         */
        BEST_NODES(1),
        /***
         * Every 18th iteration in flood a line to dest will be constructed
         * <br>Warning: The path found won't be optimal
         */
        MEDIUM(18),
        /***
         * Every 64th iteration in flood a line to dest will be constructed
         * <br>Warning: The path found won't be optimal
         */
        FAST(64),
        /***
         * Every 128th iteration in flood a line to dest will be constructed
         * <br>Warning: By using this profile, the algorithm can fail to find a solution
         * <br>Warning: The path found won't be optimal
         */
        FASTER(128),
        /***
         * Every 256th iteration in flood a line to dest will be constructed
         * <br>Warning: By using this profile, the algorithm can fail to find a solution
         * <br>Warning: The path found won't be optimal
         */
        FASTEST(256);

        private final int profile;

        Profile(int profile) {
            this.profile = profile;
        }

        public int getValue() {
            return profile;
        }
    }


    private static SharedRessources sharedRessources;

    public static SharedRessources getInstance() {
        if (sharedRessources == null)
            sharedRessources
                    = new SharedRessources();


        return sharedRessources;
    }


    private ExecutorService threadPool;

    private Int3[] data;

    private boolean[] walls;

    private int width;
    private int height;

    private Point start;
    private Point end;

    private volatile boolean found;

    private Profile currentProfile;

    private int maxCores = 1;

    private SharedRessources() {

    }

    public void initialize(int w, int h) {
        this.width = w;
        this.height = h;


        data = new Int3[width * height];
        for (int i = 0; i < data.length; i++)
            data[i] = new Int3(0, 0, Integer.MAX_VALUE);

        walls = new boolean[width * height];

        threadPool = Executors.newFixedThreadPool(maxCores);

        System.out.println("[*] Using " + maxCores + " cores.");
    }


    public void setFound(boolean found) {
        this.found = found;
    }

    public boolean isFound() {
        return found;
    }

    public void setStart(int x, int y) {
        start = new Point(x, y);
    }

    public void setEnd(int x, int y) {
        end = new Point(x, y);
    }

    public Point getStart() {
        return start;
    }

    public Point getEnd() {
        return end;
    }

    public ExecutorService getExecutor() {
        return threadPool;
    }

    public int getStep(int x, int y) {
        synchronized (this) {
            return data[x + y * width].getZ();
        }
    }

    public void setData(int x, int y, int dirX, int dirY, int step) {
        synchronized (this) {
            data[x + y * width] = new Int3(dirX, dirY, step);
        }
    }

    public Int3 getData(int x, int y) {
        synchronized (this) {
            return data[x + y * width];
        }
    }

    public boolean isWall(int x, int y) {
        return walls[x + y * width];
    }

    public void setWall(int x, int y) {
        walls[x + y * width] = true;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }


    public void setCurrentProfile(Profile profile) {
        this.currentProfile = profile;
    }

    public Profile getCurrentProfile() {
        return currentProfile;
    }

    public void setMaxCores(int cores) {
        maxCores = cores >= AVAIBLE_CORES ? AVAIBLE_CORES : cores;
    }
}
