package approach3.misc;

import approach3.parallel.SharedRessources;

import java.awt.*;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;

public class MapLoader {

    private int width;
    private int height;

    private MapLoader() {
    }

    private static MapLoader mapLoader;

    public static MapLoader getDefault() {
        if (mapLoader == null)
            mapLoader = new MapLoader();
        return mapLoader;
    }

    public void load(BufferedImage src) {
        this.width = src.getWidth();
        this.height = src.getHeight();

        SharedRessources.getInstance().initialize(width, height);

        // https://stackoverflow.com/a/9470843/14727115
        byte[] pixels = ((DataBufferByte) src.getRaster().getDataBuffer()).getData();

        for (int j = 0; j < height; j++) {
            for (int i = 0; i < width; i++) {
                if (((BufferedImage) src).getRGB(i, j) == Color.black.getRGB())
                    SharedRessources.getInstance().setWall(i, j);
            }
        }
    }

}
