package approach3.misc;

import structs.Int3;

import java.awt.*;
import java.util.HashMap;

public class Lexicon {

    private HashMap<Point, String> directionOrientation
            = new HashMap<>() {
        {
            put(new Point(+1, 0), "Osten");
            put(new Point(-1, 0), "Westen");
            put(new Point(0, -1), "Norden");
            put(new Point(0, +1), "Süden");

            put(new Point(+1, -1), "Nord-Osten");
            put(new Point(-1, -1), "Nord-Westen");

            put(new Point(+1, +1), "Süd-Osten");
            put(new Point(-1, +1), "Süd-Westen");
        }
    };

    private static Lexicon lexicon;

    public static Lexicon getInstance() {
        if (lexicon == null)
            lexicon = new Lexicon();

        return lexicon;
    }

    public String getText(Point direction) {
        return directionOrientation.get(direction);
    }
}
