package approach2.window;

import approach2.MapLoader;
import approach2.SharedRessources;
import approach2.algorithm.ParallelPathfinder;
import framework.Game;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class MainWindowApproach2 extends Game {
    public MainWindowApproach2(String title, int w, int h) {
        super(title, w, h);
    }


    ParallelPathfinder parallelPathfinder
            = new ParallelPathfinder();

    @Override
    public void loadGame() {
        SharedRessources.setMaximumCores(Integer.MAX_VALUE);

        try {
            MapLoader.getDefault().load(ImageIO.read(new File("examples/maze.png")));
        } catch (IOException e) {
            e.printStackTrace();
        }

        parallelPathfinder.flood(80 ,80);


    }


    private boolean pressed;
    ArrayList<Point> pts = new ArrayList<>();
    @Override
    public void updateGame() {

        if (isMouseKeyDown(MouseEvent.BUTTON1) && !pressed) {
            pts =
                    parallelPathfinder.calculatePath(this.getMouseX() / 10, this.getMouseY() / 10, 80, 80);
            pressed = true;
        }

        if (isMouseKeyUp(MouseEvent.BUTTON1))
            pressed = false;

    }

    @Override
    public void renderGame(Graphics g) {
        parallelPathfinder.draw(g);



        if (pts == null)
            return;

        g.setColor(Color.red);
        for (var pt : pts) {
            g.fillRect(pt.x * 10, pt.y * 10, 10, 10);
        }
    }


}
