package approach2.algorithm;

import approach2.SharedRessources;
import structs.Vec3;

import java.awt.*;
import java.util.ArrayList;

public class ParallelPathfinder {

    int lastDestX;
    int lastDestY;

    public void flood(int destX, int destY) {
        System.out.println("[*] Flooding...");

        lastDestX = destX;
        lastDestY = destY;

        SharedRessources
                .getInstance()
                .setExplorer(new Explorer(destX - 1, destY, 1));

        SharedRessources
                .getInstance()
                .setExplorer(new Explorer(destX + 1, destY, 1));

        SharedRessources
                .getInstance()
                .setExplorer(new Explorer(destX, destY - 1, 1));
        SharedRessources
                .getInstance()
                .setExplorer(new Explorer(destX, destY + 1, 1));




        SharedRessources.getInstance()
                .set(destX - 1, destY, new Vec3(1, 0, 1));

        SharedRessources.getInstance()
                .set(destX + 1, destY, new Vec3(-1, 0, 1));

        SharedRessources.getInstance()
                .set(destX, destY - 1, new Vec3(0, +1, 1));

        SharedRessources.getInstance()
                .set(destX, destY + 1, new Vec3(0, -1, 1));


        SharedRessources
                .getInstance().start();

    }

    public ArrayList<Point> calculatePath(int startX, int startY, int destX, int destY) {
        ArrayList<Point> path
                = new ArrayList<>();

        int x = startX;
        int y = startY;

        while (x != destX || y != destY) {

            path.add(new Point(x, y));

            Vec3 currentDir
                    =
                    SharedRessources.getInstance().getData(x, y);

            int dx = (int) currentDir.getX();
            int dy = (int) currentDir.getY();

            if (dx == 0 && dy == 0)
                return null;

            x += dx;
            y += dy;
        }

        System.out.println("Done.");

        return path;
    }

    public void draw(Graphics g) {

        for (int j = 0; j < SharedRessources.getInstance().getHeight(); j++) {
            for (int i = 0; i < SharedRessources.getInstance().getWidth(); i++) {


                if (SharedRessources.getInstance().isWall(i, j)) {
                    g.setColor(Color.blue);
                    g.fillRect(i * 10, j * 10, 10, 10);
                }
                else {


                    int dx = (int) SharedRessources.getInstance().getData(i, j).getX() * 5;
                    int dy = (int) SharedRessources.getInstance().getData(i, j).getY() * 5;

                    if (dx != 0 || dy != 0) {
                        int green = SharedRessources.getInstance().getStep(i, j);
                        if (green >= 255)
                            green = 255;
                        Color color
                                = new Color(0, green, 0);

                        g.setColor(color);

                        g.fillRect(i * 10, j * 10, 10, 10);

                        g.setColor(Color.red);
                        g.drawLine(i * 10, j * 10, i * 10 + dx, j * 10 + dy);



                    } else {
                        g.setColor(Color.black);
                        g.fillRect(i * 10, j * 10, 10, 10);
                    }
                }




            }
        }
    }
}
