package approach2.algorithm;

import approach2.SharedRessources;
import structs.Vec3;

import java.awt.*;
import java.awt.geom.Point2D;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Queue;
import java.util.Stack;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Explorer {

    private int px;
    private int py;

    private int steps;

    public Explorer(int x, int y, int steps) {
        this.px = x;
        this.py = y;
        this.steps = steps;
    }

    private Queue<Point> openPoints
            = new ArrayDeque<>();

    public void explore() {
        openPoints.offer(new Point(px, py));


        while (!openPoints.isEmpty()) {
            Point cur
                    = openPoints.poll();

            int x = cur.x;
            int y = cur.y;



            boolean
                    left = SharedRessources.getInstance().isWall(x - 1, y) ;
            boolean
                    right = SharedRessources.getInstance().isWall(x + 1, y) ;
            boolean up
                    = SharedRessources.getInstance().isWall(x, y - 1) ;
            boolean down
                    = SharedRessources.getInstance().isWall(x, y + 1) ;

            boolean leftUp =
                    SharedRessources.getInstance().isWall(x - 1, y- 1);
            boolean rightUp =
                    SharedRessources.getInstance().isWall(x + 1, y- 1);

            boolean leftDown =
                    SharedRessources.getInstance().isWall(x - 1, y + 1);
            boolean rightDown =
                    SharedRessources.getInstance().isWall(x + 1, y + 1);



            int stepLeft
                    = SharedRessources.getInstance().getStep(x - 1, y);
            int stepRight
                    = SharedRessources.getInstance().getStep(x + 1, y);
            int stepUp
                    = SharedRessources.getInstance().getStep(x, y - 1);
            int stepDown
                    = SharedRessources.getInstance().getStep(x, y + 1);

            if(!left && !right && !up && !down && !rightDown && !rightUp && !leftDown && !leftUp)
                continue;

            if (!left) {
                if (steps < stepLeft) {
                    SharedRessources.getInstance()
                            .set(x - 1, y, new Vec3(1, 0, steps + 1));

                    openPoints
                            .offer(new Point(x - 1, y));

                }
            }

            if (!right) {
                if (steps < stepRight) {
                    SharedRessources.getInstance()
                            .set(x + 1, y, new Vec3(-1, 0, steps + 1));


                    openPoints
                            .offer(new Point(x + 1, y));
                }
            }

            if (!up) {
                if (steps < stepUp) {
                    SharedRessources.getInstance()
                            .set(x, y - 1, new Vec3(0, 1, steps + 1));


                    openPoints
                            .offer(new Point(x, y - 1));
                }
            }

            if (!down) {
                if (steps < stepDown) {
                    SharedRessources.getInstance()
                            .set(x, y + 1, new Vec3(0, -1, steps + 1));


                    openPoints
                            .offer(new Point(x, y + 1));
                }
            }



            steps++;




        }


        System.out.println("Done.");

    }


}
