package approach2;

import approach1.algorithm.WorkingExplorers;
import approach2.algorithm.Explorer;
import structs.Vec3;

public class SharedRessources {

    private static SharedRessources sharedRessources;

    public static SharedRessources getInstance() {
        if (sharedRessources == null)
            sharedRessources = new SharedRessources(USING_CORES);
        return sharedRessources;
    }

    private static int USING_CORES;

    /***
     * Use Integer.MAX_VALUE for all cores
     * @param cores
     */
    public static void setMaximumCores(int cores) {
        if (cores >= Runtime.getRuntime().availableProcessors())
            cores = Runtime.getRuntime().availableProcessors();
        USING_CORES = cores;
    }

    private int width;
    private int height;

    private boolean[] wallMatrix;
    private boolean[] visitMatrix;

    private Vec3[] directionMatrix;

    private int maxCores;
    private int currentCore;

    private ExplorerThread[] workingThreads;


    private SharedRessources(int cores) {
        maxCores = cores;
        currentCore = 0;

        System.out.println("[*] Using " + maxCores + " cores.");

        workingThreads = new ExplorerThread[maxCores];
        for (int i = 0; i < maxCores; i++)
            workingThreads[i] = new ExplorerThread();
    }

    public void initializeArrays() {
        wallMatrix = new boolean[width * height];
        visitMatrix = new boolean[width * height];
        directionMatrix = new Vec3[width * height];

        for (int i = 0; i < directionMatrix.length; i++)
            directionMatrix[i] = new Vec3(0, 0, Integer.MAX_VALUE);
    }

    public void setExplorer(Explorer explorer) {
        int index
                = (currentCore++) % maxCores;

        workingThreads[index]
                .setExplorer(explorer);
    }

    public void start() {
        for (int i = 0; i < maxCores; i++)
            workingThreads[i].start();
    }


    public int getWidth() {
        return width;
    }

    public int getHeight() {
        return height;
    }

    protected void setWidth(int width) {
        this.width = width;
    }

    protected void setHeight(int height) {
        this.height = height;
    }

    protected void setWall(int x, int y) {
        wallMatrix[x + y * width] = true;
    }

    public boolean isWall(int x, int y) {
        return wallMatrix[x + y * width];
    }

    public int getStep(int x, int y) {
        return (int) directionMatrix[x + y * width].getZ();
    }

    public void visit(int x, int y) {
        visitMatrix[x + y * width] = true;
    }

    public boolean isVisited(int x, int y) {
        return visitMatrix[x + y * width];
    }

    public Vec3 getData(int x, int y) {
        return directionMatrix[x + y * width];
    }

    public void set(int x, int y, Vec3 data) {
        directionMatrix[x + y * width]
                = new Vec3(data.getX(), data.getY(), data.getZ());
    }
}
