package approach1.window;

import approach1.algorithm.ParallelPathfinder;
import approach1.parallel.MapLoader;
import approach1.parallel.SharedRessources;
import framework.Game;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class MainWindowApproach1 extends Game {
    public MainWindowApproach1(String title, int w, int h) {
        super(title, w, h);
    }


    private ParallelPathfinder parallelPathfinder;
    private ArrayList<Point> pts;

    @Override
    public void loadGame() {
        SharedRessources.setMaximumCores(1);
        SharedRessources.setEpsilon(0);
        SharedRessources.useQueue(true);

        try {
            // MAZE GENERATED WITH http://www.mazegenerator.net/
            MapLoader.getDefault().load(ImageIO.read(new File("examples/maze.png")));
        } catch (IOException e) {
            e.printStackTrace();
        }
        parallelPathfinder
                = new ParallelPathfinder();
    }

    private boolean pressed;

    @Override
    public void updateGame() {

        if (isMouseKeyDown(MouseEvent.BUTTON1) && !pressed) {
            pts =
                    parallelPathfinder.calculatePath(this.getMouseX(), this.getMouseY(), 1590, 800);
            pressed = true;
        }

        if (isMouseKeyUp(MouseEvent.BUTTON1))
            pressed = false;
    }

    @Override
    public void renderGame(Graphics g) {

        if (parallelPathfinder == null)
            return;

        parallelPathfinder.draw(g);


        if (pts == null)
            return;

        g.setColor(Color.red);
        for (var pt : pts) {
            g.fillRect(pt.x - 2, pt.y - 2, 4, 4);
        }
    }

}
