package approach1.parallel;

import structs.Vec3;

import java.awt.*;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;

public class MapLoader {

    private int width;
    private int height;

    private MapLoader() {
    }

    private static MapLoader mapLoader;

    public static MapLoader getDefault() {
        if (mapLoader == null)
            mapLoader = new MapLoader();
        return mapLoader;
    }

    public void load(BufferedImage src) {
        this.width = src.getWidth();
        this.height = src.getHeight();

        SharedRessources.getInstance().setWidth(width);
        SharedRessources.getInstance().setHeight(height);

        SharedRessources.getInstance().setVisitMatrix(new Vec3[width * height]);
        SharedRessources.getInstance().setWallMatrix(new boolean[width * height]);

        for (int i = 0; i < SharedRessources.getInstance().getVisitMatrix().length; i++)
            SharedRessources.getInstance().getVisitMatrix()[i] = new Vec3(0, 0, Integer.MAX_VALUE);


        // https://stackoverflow.com/a/9470843/14727115
        byte[] pixels = ((DataBufferByte) src.getRaster().getDataBuffer()).getData();


        for (int j = 0; j < height; j++) {
            for (int i = 0; i < width; i++) {
                SharedRessources.getInstance().getWallMatrix()[i + j * width] =
                        ((BufferedImage) src).getRGB(i, j) == Color.black.getRGB();
            }
        }
    }

}
