package approach1.parallel;

public abstract class EagerWorkingThread extends Thread {

    private volatile int triggerCount;
    private volatile boolean isTriggered;
    private volatile boolean listen;

    public void startListen() {
        listen = true;
    }

    public void stopListen() {
        listen = false;
    }

    @Override
    public void run() {
        while (listen) {
            synchronized (this) {
                while (!isTriggered) {
                    try {
                        this.wait();
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            onBegin();
            for (int i = 0; i < triggerCount; i++)
                onTrigger();
            onEnd();

            triggerCount = 0;
            isTriggered = false;

        }
    }

    public boolean trigger() {
        triggerCount++;
        isTriggered = true;
        synchronized (this) {
            this.notify();
        }
        return true;
    }

    public boolean isReady() {
        return this.triggerCount == 0;
    }

    public abstract void onBegin();

    public abstract void onTrigger();

    public abstract void onEnd();

}
