package approach1.algorithm;

import approach1.parallel.EagerWorkingThread;
import approach1.parallel.SharedRessources;

import java.util.*;
import java.util.concurrent.ConcurrentLinkedQueue;

public class WorkingExplorers extends EagerWorkingThread {

    private Collection<Explorer> currentWaitingExplorers;

    public WorkingExplorers() {
        super();
        this.startListen();
        System.out.println("[*] Thread initialized @" + this.getName());

        if (SharedRessources.isUsingQueue())
            currentWaitingExplorers
                    = new ConcurrentLinkedQueue<>();
        else currentWaitingExplorers = new Stack<Explorer>();

    }

    @Override
    public void onBegin() {
    }

    @Override
    public void onTrigger() {
        if (!currentWaitingExplorers.isEmpty()) {

            if (SharedRessources.isUsingQueue())
                ((ConcurrentLinkedQueue<Explorer>) currentWaitingExplorers)
                        .poll()
                        .explore();
            else ((Stack<Explorer>) currentWaitingExplorers)
                    .pop()
                    .explore();
        }
    }

    @Override
    public void onEnd() {
        synchronized (SharedRessources.getInstance().getSignalingObject()) {
            SharedRessources.getInstance().getSignalingObject().notifyAll();
        }
    }

    public void add(Explorer explorer) {

        if (SharedRessources.isUsingQueue())
            ((ConcurrentLinkedQueue<Explorer>) currentWaitingExplorers)
                    .offer(explorer);
        else ((Stack<Explorer>) currentWaitingExplorers)
                .push(explorer);

        this.trigger();
    }

}
