package approach1.algorithm;

import approach1.parallel.SharedRessources;
import structs.Vec3;

import java.awt.*;
import java.util.ArrayList;

public class ParallelPathfinder {

    private int lastDestX;
    private int lastDestY;

    private void flood(int destX, int destY) {

        lastDestX = destX;
        lastDestY = destY;

        System.out.println("[*] Flooding...");

        SharedRessources
                .getInstance().add(new Explorer(destX - 1, destY, 1, Explorer.Direction.West));
        SharedRessources
                .getInstance().add(new Explorer(destX + 1, destY, 1, Explorer.Direction.East));
        SharedRessources
                .getInstance().add(new Explorer(destX, destY - 1, 1, Explorer.Direction.North));
        SharedRessources
                .getInstance().add(new Explorer(destX, destY + 1, 1, Explorer.Direction.South));


        synchronized (SharedRessources.getInstance().getSignalingObject()) {
            while (!SharedRessources.getInstance().done()) {
                try {
                    SharedRessources.getInstance().getSignalingObject().wait();
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public ArrayList<Point> calculatePath(int startX, int startY, int destX, int destY) {

        if (destX != lastDestX || destY != lastDestY)
            flood(destX, destY);

        ArrayList<Point> path
                = new ArrayList<>();

        int x = startX;
        int y = startY;

        while (x != destX || y != destY) {

            path.add(new Point(x, y));

            Vec3 currentDir
                    =
                    SharedRessources.getInstance().getVisitMatrix()[x + y * SharedRessources.getInstance().getWidth()];

            int dx = (int) currentDir.getX();
            int dy = (int) currentDir.getY();

            if (dx == 0 && dy == 0)
                return null;

            x += dx;
            y += dy;
        }
        return path;
    }

    public void draw(Graphics g) {
        for (int j = 0; j < SharedRessources.getInstance().getHeight(); j++) {
            for (int i = 0; i < SharedRessources.getInstance().getWidth(); i++) {
                boolean b =
                        SharedRessources.getInstance().getWallMatrix()[i + j * SharedRessources.getInstance().getWidth()];
                if (b) {
                    g.setColor(Color.blue);

                } else {
                    Vec3 currentVec
                            =
                            SharedRessources.getInstance().getVisitMatrix()[i + j * SharedRessources.getInstance().getWidth()];
                    if (currentVec.getX() == 0 && currentVec.getY() == 0)
                        g.setColor(Color.black);
                    else {
                        int green = (int) currentVec.getZ();
                        if (green >= 255)
                            green = 255;

                        Color color
                                = new Color(0, green, 0);

                        g.setColor(color);

                    }

                    g.fillRect(i * 1, j * 1, 1, 1);
                }
            }
        }
    }
}
