package approach1.algorithm;

import approach1.parallel.SharedRessources;
import structs.Vec3;

public class Explorer {

    public enum Direction {
        North,
        East,
        South,
        West
    }

    private int x;
    private int y;

    private int steps;

    private Direction direction;

    public Explorer(int x, int y, int steps, Direction direction) {
        this.x = x;
        this.y = y;
        this.steps = steps;
        this.direction = direction;
    }

    public void explore() {
        int index = x + y * SharedRessources.getInstance().getWidth();
        int currentStepsOnField
                =
                (int) SharedRessources.getInstance().getVisitMatrix()[index]
                        .getZ();

        if (currentStepsOnField <= steps + SharedRessources.getEpsilon()) {
            return;
        }

        boolean wall =
                SharedRessources.getInstance().getWallMatrix()[index];
        if (wall)
            return;

        Explorer recursiveNext
                = null;

        switch (direction) {

            case North:

                SharedRessources
                        .getInstance().getVisitMatrix()[index]
                        = new Vec3(0, +1, steps);

                recursiveNext
                        = new Explorer(x, y - 1, steps++, direction);
                addLeftRight();
                break;

            case East:

                SharedRessources
                        .getInstance().getVisitMatrix()[index]
                        = new Vec3(-1, 0, steps);

                recursiveNext
                        = new Explorer(x + 1, y, steps++, direction);

                addUpDown();
                break;

            case South:

                SharedRessources
                        .getInstance().getVisitMatrix()[index]
                        = new Vec3(0, -1, steps);

                recursiveNext
                        = new Explorer(x, y + 1, steps++, direction);
                addLeftRight();
                break;

            case West:

                SharedRessources
                        .getInstance().getVisitMatrix()[index]
                        = new Vec3(+1, 0, steps);

                recursiveNext
                        = new Explorer(x - 1, y, steps++, direction);
                addUpDown();
                break;

        }


        recursiveNext.explore();
    }


    private void addLeftRight() {
        SharedRessources
                .getInstance().add(new Explorer(x - 1, y, steps++, Direction.West));

        SharedRessources
                .getInstance().add(new Explorer(x + 1, y, steps++, Direction.East));

    }

    private void addUpDown() {
        SharedRessources
                .getInstance().add(new Explorer(x, y - 1, steps++, Direction.North));

        SharedRessources
                .getInstance().add(new Explorer(x, y + 1, steps++, Direction.South));
    }


}
